<?php
// session_start() మరియు $user_data dashboard.php నుండి వస్తుంది

if (!isset($_SESSION['user_data'])) {
    echo "Unauthorized Access";
    exit();
}

$user_data = $_SESSION['user_data'];

$name = $user_data['first_name'] . ' ' . $user_data['last_name'];

// Photo path logic
$path = "uploads/" . $user_data['photo'];
if (!file_exists($path) || empty($user_data['photo'])) {
    $path = "uploads/default.png";
}
?>

<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Profile</title>

    <style>
        body {
            font-family: Inter, Arial;
            background: #f7f9fc;
            padding: 0;
        }
        .card {
            max-width: 520px;
            margin: 20px auto;
            background: #fff;
            padding: 24px;
            border-radius: 10px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.06);
            text-align: center;
        }
        .card img {
            width: 110px;
            height: 110px;
            border-radius: 50%;
            object-fit: cover;
            margin-bottom: 12px;
        }
        .label {
            color: #666;
            font-weight: 600;
            margin-top: 8px;
        }
        .value {
            font-size: 15px;
            color: #111;
            margin-bottom: 8px;
        }
    </style>
</head>

<body>

<div class="card">
    <img src="<?php echo htmlspecialchars($path); ?>" alt="photo">

    <h2><?php echo htmlspecialchars($name); ?></h2>

    <div class="label">User ID</div>
    <div class="value"><?php echo htmlspecialchars($user_data['id']); ?></div>

    <div class="label">Email</div>
    <div class="value"><?php echo htmlspecialchars($user_data['email']); ?></div>

    <div class="label">Username</div>
    <div class="value"><?php echo htmlspecialchars($user_data['username']); ?></div>

    <div class="label">Phone</div>
    <div class="value"><?php echo htmlspecialchars($user_data['phone']); ?></div>

    <div class="label">Partnered On</div>
    <div class="value"><?php echo htmlspecialchars($user_data['partnered_on']); ?></div>

    <div class="label">Created At</div>
    <div class="value"><?php echo htmlspecialchars($user_data['created_at']); ?></div>
</div>

</body>
</html>
