<?php 
session_start();
if (!isset($_SESSION['client_id'])) { echo "Unauthorized"; exit(); }

$host = "localhost";
$user = "thevkin_schlautdb";
$pass = "VK_AutSchlDb";
$db   = "thevkin_schlautdb";

$conn = mysqli_connect($host, $user, $pass, $db);
if (!$conn) die("DB Err: " . mysqli_connect_error());

$msg = "";
$cls = "";

/* --------------------------------------
   Generate next Branch Code (#VKBR01…)
----------------------------------------- */
function generateBranchID($conn) {
    $res = mysqli_query($conn, "SELECT id FROM branches ORDER BY created_at DESC, id DESC LIMIT 1");

    if (!$res) return "DB_QUERY_ERROR: " . mysqli_error($conn);

    if (mysqli_num_rows($res) == 0) return "#VKBR01";

    $row = mysqli_fetch_assoc($res);
    $last = $row['id'];

    if (!preg_match('/^#VKBR(\d+)$/', $last, $m)) return "#VKBR01";

    $num = (int)$m[1] + 1;
    return "#VKBR" . str_pad($num, 2, "0", STR_PAD_LEFT);
}

/* --------------------------------------
   Create Branch
----------------------------------------- */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_branch'])) {

    $branch_name = trim($_POST['branch_name']);

    if ($branch_name === '') {
        $msg = "Please enter branch name.";
        $cls = "error";

    } else {

        $branch_name_esc = mysqli_real_escape_string($conn, $branch_name);
        $branch_code     = generateBranchID($conn);

        // Logged-in user ID (STRING LIKE #VKCL01)
        $created_by = $_SESSION['client_id'];

        if (empty($created_by)) {
            $msg = "Error: Invalid Client ID. Please re-login.";
            $cls = "error";

        } else {

            $stmt = mysqli_prepare($conn, 
                "INSERT INTO branches (id, name, created_by, created_at)
                 VALUES (?, ?, ?, NOW())"
            );

            if (!$stmt) {
                $msg = "DB Error: " . mysqli_error($conn);
                $cls = "error";

            } else {

               // All strings → sss
mysqli_stmt_bind_param($stmt, "sss",
    $branch_code,
    $branch_name_esc,
    $created_by // <-- This is passed as a string
);

                if (mysqli_stmt_execute($stmt)) {
                    $msg = "Branch created successfully: " . htmlspecialchars($branch_code);
                    $cls = "success";
                } else {
                    $msg = "DB Execute Error: " . mysqli_stmt_error($stmt);
                    $cls = "error";
                }

                mysqli_stmt_close($stmt);
            }
        }
    }
}
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Add Branch</title>
<style>
body{font-family:Inter,Arial;background:#f4f6ff;padding:18px;}
.box{max-width:520px;margin:10px auto;background:#fff;padding:20px;border-radius:10px;box-shadow:0 6px 18px rgba(0,0,0,0.08);}
input,button{width:100%;padding:12px;margin-top:10px;border-radius:8px;border:1px solid #ccc;font-size:15px;}
button{background:#0077ff;color:#fff;border:0;cursor:pointer;}
.success{background:#e6ffec;padding:10px;border-radius:6px;color:#1d6d2e;margin-bottom:10px;}
.error{background:#ffe6e6;padding:10px;border-radius:6px;color:#8a1f1f;margin-bottom:10px;}
</style>
</head>
<body>

<div class="box">
    <h3>Add Branch</h3>

    <?php if ($msg !== ""): ?>
        <div class="<?php echo $cls; ?>"><?php echo htmlspecialchars($msg); ?></div>
    <?php endif; ?>

    <form method="post">
        <input type="text" name="branch_name" placeholder="Branch name (e.g. Hyderabad Main)" required>
        <button name="submit_branch" type="submit">Create Branch</button>
    </form>
</div>

</body>
</html>
